
#include "Perus.h"





void AlustaSyottolaiteMoottori(NAPPAIMET &Nappaimet, HIIRI &Hiiri, unsigned short RuudunLeveys, unsigned short RuudunKorkeus )
{
    Nappaimet.Alusta();
    Hiiri.Alusta( RuudunLeveys, RuudunKorkeus );
}

void PaivitaSyottolaiteMoottori(NAPPAIMET &Nappaimet, HIIRI &Hiiri, SDL_Event &Tapahtuma)
{
    Nappaimet.Paivita( Tapahtuma );
    Hiiri.Paivita( Tapahtuma );
}





void HIIRI::Alusta( unsigned short Leveys, unsigned short Korkeus )
{
    RuudunLeveys = Leveys;
    RuudunKorkeus = Korkeus;
    NappienLKM = HIIRENNAPPIENLKM;
    NappiTiedot = new HIIRENNAPPITIEDOT [NappienLKM];
    
    NappiTiedot[BUT_LEFT].SDL_NapinID = SDL_BUTTON_LEFT;
    NappiTiedot[BUT_MIDDLE].SDL_NapinID = SDL_BUTTON_MIDDLE;
    NappiTiedot[BUT_RIGHT].SDL_NapinID = SDL_BUTTON_RIGHT;

    for(int i=0; i<NappienLKM;i++){ NappiTiedot[i].Tila = Vapaa; }
    X = 0;
    Y = 0;
    Xd = 0;
    Yd = 0;
}

void HIIRI::Paivita( SDL_Event &Tapahtuma )
{
    switch(Tapahtuma.type)
    {
        case SDL_MOUSEMOTION:
            X = (double)Tapahtuma.motion.x/RuudunLeveys * 1280;
            Y = (double)(RuudunKorkeus-Tapahtuma.motion.y - 1)/RuudunKorkeus * 1024;
            Xd = Tapahtuma.motion.xrel; Tapahtuma.motion.xrel = 0;
            Yd = Tapahtuma.motion.yrel; Tapahtuma.motion.yrel = 0;
        break;
    }
    
    for(int i=0; i<NappienLKM; i++)
    {
        bool MuutosTilassa = false;
       
        if(Tapahtuma.button.button == NappiTiedot[i].SDL_NapinID)
        {
            switch(Tapahtuma.button.type)
            {
                case SDL_MOUSEBUTTONDOWN: 
                    if(NappiTiedot[i].Tila == Vapaa){ NappiTiedot[i].Tila = Painettu; MuutosTilassa = true; }
                break;
                case SDL_MOUSEBUTTONUP:
                    if(NappiTiedot[i].Tila == Pohjassa){ NappiTiedot[i].Tila = Nostettu; MuutosTilassa = true; }
                break;
            }
        }
        
        if(!MuutosTilassa)
        {
            if(NappiTiedot[i].Tila == Painettu){ NappiTiedot[i].Tila = Pohjassa; }
            if(NappiTiedot[i].Tila == Nostettu){ NappiTiedot[i].Tila = Vapaa; }            
        }
    }
}


unsigned char HIIRI::NapinTila( unsigned char Nappi )
{
    return NappiTiedot[Nappi].Tila;
}

float HIIRI::AnnaX(){ return X; }
float HIIRI::AnnaY(){ return Y; }
float HIIRI::AnnaXd(){ return Xd; }
float HIIRI::AnnaYd(){ return Yd; }


bool HIIRI::OnkoSisalla( double TarkasteltavaX, double TarkasteltavaY, double TarkasteltavaLeveys, double TarkasteltavaKorkeus )
{
    if(X >= TarkasteltavaX && X <= (TarkasteltavaX+TarkasteltavaLeveys) 
    && Y >= TarkasteltavaY && Y <= (TarkasteltavaY+TarkasteltavaKorkeus))
        return true;
    
    else return false;
}






void NAPPAIMET::Paivita( SDL_Event &Tapahtuma )
{
    for(int i=0; i<NappaintenLKM; i++)
    {
        bool MuutosTilassa = false;
       
        if(Tapahtuma.key.keysym.sym == NappainTiedot[i].sym)
        {
            switch(Tapahtuma.type)
            {
                case SDL_KEYDOWN: 
                    if(NappainTiedot[i].Tila == Vapaa){ NappainTiedot[i].Tila = Painettu; MuutosTilassa = true; }
                break;
                case SDL_KEYUP:
                    if(NappainTiedot[i].Tila == Pohjassa){ NappainTiedot[i].Tila = Nostettu; MuutosTilassa = true; }
                break;
            }
        }
        
        if(!MuutosTilassa)
        {
            if(NappainTiedot[i].Tila == Painettu){ NappainTiedot[i].Tila = Pohjassa; }
            if(NappainTiedot[i].Tila == Nostettu){ NappainTiedot[i].Tila = Vapaa; }            
        }
    }
}


unsigned char NAPPAIMET::NapinTila( unsigned char Nappain )
{
    return NappainTiedot[Nappain].Tila;
}


void NAPPAIMET::Alusta()
{
    NappaintenLKM = NAPPAINTENLKM;
    NappainTiedot = new NAPPAINTIEDOT [NappaintenLKM];

    for(int i=0; i<NappaintenLKM;i++){ NappainTiedot[i].Tila = Vapaa; }

    NappainTiedot[NAP_BACKSPACE].sym = SDLK_BACKSPACE;
    NappainTiedot[NAP_TAB].sym = SDLK_TAB;
    NappainTiedot[NAP_CLEAR].sym = SDLK_CLEAR;
    NappainTiedot[NAP_RETURN].sym = SDLK_RETURN;
    NappainTiedot[NAP_PAUSE].sym = SDLK_PAUSE;
    NappainTiedot[NAP_ESCAPE].sym = SDLK_ESCAPE;
    NappainTiedot[NAP_SPACE].sym = SDLK_SPACE;
    NappainTiedot[NAP_EXCLAIM].sym = SDLK_EXCLAIM;
    NappainTiedot[NAP_QUOTEDBL].sym = SDLK_QUOTEDBL;
    NappainTiedot[NAP_HASH].sym = SDLK_HASH;
    NappainTiedot[NAP_DOLLAR].sym = SDLK_DOLLAR;
    NappainTiedot[NAP_AMPERSAND].sym = SDLK_AMPERSAND;
    NappainTiedot[NAP_QUOTE].sym = SDLK_QUOTE;
    NappainTiedot[NAP_LEFTPAREN].sym = SDLK_LEFTPAREN;
    NappainTiedot[NAP_RIGHTPAREN].sym = SDLK_RIGHTPAREN;
    NappainTiedot[NAP_ASTERISK].sym = SDLK_ASTERISK;
    NappainTiedot[NAP_PLUS].sym = SDLK_PLUS;
    NappainTiedot[NAP_COMMA].sym = SDLK_COMMA;
    NappainTiedot[NAP_MINUS].sym = SDLK_MINUS;
    NappainTiedot[NAP_PERIOD].sym = SDLK_PERIOD;
    NappainTiedot[NAP_SLASH].sym = SDLK_SLASH;
    NappainTiedot[NAP_0].sym = SDLK_0;
    NappainTiedot[NAP_1].sym = SDLK_1;
    NappainTiedot[NAP_2].sym = SDLK_2;
    NappainTiedot[NAP_3].sym = SDLK_3;
    NappainTiedot[NAP_4].sym = SDLK_4;
    NappainTiedot[NAP_5].sym = SDLK_5;
    NappainTiedot[NAP_6].sym = SDLK_6;
    NappainTiedot[NAP_7].sym = SDLK_7;
    NappainTiedot[NAP_8].sym = SDLK_8;
    NappainTiedot[NAP_9].sym = SDLK_9;
    NappainTiedot[NAP_COLON].sym = SDLK_COLON;
    NappainTiedot[NAP_SEMICOLON].sym = SDLK_SEMICOLON;
    NappainTiedot[NAP_LESS].sym = SDLK_LESS;
    NappainTiedot[NAP_EQUALS].sym = SDLK_EQUALS;
    NappainTiedot[NAP_GREATER].sym = SDLK_GREATER;
    NappainTiedot[NAP_QUESTION].sym = SDLK_QUESTION;
    NappainTiedot[NAP_AT].sym = SDLK_AT;
    NappainTiedot[NAP_LEFTBRACKET].sym = SDLK_LEFTBRACKET;
    NappainTiedot[NAP_BACKSLASH].sym = SDLK_BACKSLASH;
    NappainTiedot[NAP_RIGHTBRACKET].sym = SDLK_RIGHTBRACKET;
    NappainTiedot[NAP_CARET].sym = SDLK_CARET;
    NappainTiedot[NAP_UNDERSCORE].sym = SDLK_UNDERSCORE;
    NappainTiedot[NAP_BACKQUOTE].sym = SDLK_BACKQUOTE;
    NappainTiedot[NAP_A].sym = SDLK_a;
    NappainTiedot[NAP_B].sym = SDLK_b;
    NappainTiedot[NAP_C].sym = SDLK_c;
    NappainTiedot[NAP_D].sym = SDLK_d;
    NappainTiedot[NAP_E].sym = SDLK_e;
    NappainTiedot[NAP_F].sym = SDLK_f;
    NappainTiedot[NAP_G].sym = SDLK_g;
    NappainTiedot[NAP_H].sym = SDLK_h;
    NappainTiedot[NAP_I].sym = SDLK_i;
    NappainTiedot[NAP_J].sym = SDLK_j;
    NappainTiedot[NAP_K].sym = SDLK_k;
    NappainTiedot[NAP_L].sym = SDLK_l;
    NappainTiedot[NAP_M].sym = SDLK_m;
    NappainTiedot[NAP_N].sym = SDLK_n;
    NappainTiedot[NAP_O].sym = SDLK_o;
    NappainTiedot[NAP_P].sym = SDLK_p;
    NappainTiedot[NAP_Q].sym = SDLK_q;
    NappainTiedot[NAP_R].sym = SDLK_r;
    NappainTiedot[NAP_S].sym = SDLK_s;
    NappainTiedot[NAP_T].sym = SDLK_t;
    NappainTiedot[NAP_U].sym = SDLK_u;
    NappainTiedot[NAP_V].sym = SDLK_v;
    NappainTiedot[NAP_W].sym = SDLK_w;
    NappainTiedot[NAP_X].sym = SDLK_x;
    NappainTiedot[NAP_Y].sym = SDLK_y;
    NappainTiedot[NAP_Z].sym = SDLK_z;
    NappainTiedot[NAP_DELETE].sym = SDLK_DELETE;
    NappainTiedot[NAP_KP0].sym = SDLK_KP0;
    NappainTiedot[NAP_KP1].sym = SDLK_KP1;
    NappainTiedot[NAP_KP2].sym = SDLK_KP2;
    NappainTiedot[NAP_KP3].sym = SDLK_KP3;
    NappainTiedot[NAP_KP4].sym = SDLK_KP4;
    NappainTiedot[NAP_KP5].sym = SDLK_KP5;
    NappainTiedot[NAP_KP6].sym = SDLK_KP6;
    NappainTiedot[NAP_KP7].sym = SDLK_KP7;
    NappainTiedot[NAP_KP8].sym = SDLK_KP8;
    NappainTiedot[NAP_KP9].sym = SDLK_KP9;
    NappainTiedot[NAP_KP_PERIOD].sym = SDLK_KP_PERIOD;
    NappainTiedot[NAP_KP_DIVIDE].sym = SDLK_KP_DIVIDE;
    NappainTiedot[NAP_KP_MULTIPLY].sym = SDLK_KP_MULTIPLY;
    NappainTiedot[NAP_KP_MINUS].sym = SDLK_KP_MINUS;
    NappainTiedot[NAP_KP_PLUS].sym = SDLK_KP_PLUS;
    NappainTiedot[NAP_KP_ENTER].sym = SDLK_KP_ENTER;
    NappainTiedot[NAP_KP_EQUALS].sym = SDLK_KP_EQUALS;
    NappainTiedot[NAP_UP].sym = SDLK_UP;
    NappainTiedot[NAP_DOWN].sym = SDLK_DOWN;
    NappainTiedot[NAP_RIGHT].sym = SDLK_RIGHT;
    NappainTiedot[NAP_LEFT].sym = SDLK_LEFT;
    NappainTiedot[NAP_INSERT].sym = SDLK_INSERT;
    NappainTiedot[NAP_HOME].sym = SDLK_HOME;
    NappainTiedot[NAP_END].sym = SDLK_END;
    NappainTiedot[NAP_PAGEUP].sym = SDLK_PAGEUP;
    NappainTiedot[NAP_PAGEDOWN].sym = SDLK_PAGEDOWN;
    NappainTiedot[NAP_F1].sym = SDLK_F1;
    NappainTiedot[NAP_F2].sym = SDLK_F2;
    NappainTiedot[NAP_F3].sym = SDLK_F3;
    NappainTiedot[NAP_F4].sym = SDLK_F4;
    NappainTiedot[NAP_F5].sym = SDLK_F5;
    NappainTiedot[NAP_F6].sym = SDLK_F6;
    NappainTiedot[NAP_F7].sym = SDLK_F7;
    NappainTiedot[NAP_F8].sym = SDLK_F8;
    NappainTiedot[NAP_F9].sym = SDLK_F9;
    NappainTiedot[NAP_F10].sym = SDLK_F10;
    NappainTiedot[NAP_F11].sym = SDLK_F11;
    NappainTiedot[NAP_F12].sym = SDLK_F12;
    NappainTiedot[NAP_F13].sym = SDLK_F13;
    NappainTiedot[NAP_F14].sym = SDLK_F14;
    NappainTiedot[NAP_F15].sym = SDLK_F15;
    NappainTiedot[NAP_NUMLOCK].sym = SDLK_NUMLOCK;
    NappainTiedot[NAP_CAPSLOCK].sym = SDLK_CAPSLOCK;
    NappainTiedot[NAP_SCROLLOCK].sym = SDLK_SCROLLOCK;
    NappainTiedot[NAP_RSHIFT].sym = SDLK_RSHIFT;
    NappainTiedot[NAP_LSHIFT].sym = SDLK_LSHIFT;
    NappainTiedot[NAP_RCTRL].sym = SDLK_RCTRL;
    NappainTiedot[NAP_LCTRL].sym = SDLK_LCTRL;
    NappainTiedot[NAP_RALT].sym = SDLK_RALT;
    NappainTiedot[NAP_LALT].sym = SDLK_LALT;
    NappainTiedot[NAP_RMETA].sym = SDLK_RMETA;
    NappainTiedot[NAP_LMETA].sym = SDLK_LMETA;
    NappainTiedot[NAP_LSUPER].sym = SDLK_LSUPER;
    NappainTiedot[NAP_RSUPER].sym = SDLK_RSUPER;
    NappainTiedot[NAP_MODE].sym = SDLK_MODE;
    NappainTiedot[NAP_HELP].sym = SDLK_HELP;
    NappainTiedot[NAP_PRINT].sym = SDLK_PRINT;
    NappainTiedot[NAP_SYSREQ].sym = SDLK_SYSREQ;
    NappainTiedot[NAP_BREAK].sym = SDLK_BREAK;
    NappainTiedot[NAP_MENU].sym = SDLK_MENU;
    NappainTiedot[NAP_POWER].sym = SDLK_POWER;
    NappainTiedot[NAP_EURO].sym = SDLK_EURO;


}


































